import { HttpModule } from '@nestjs/axios';
import { Global, Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { JwtModule } from '@nestjs/jwt';
import { EntitiesModule } from 'src/entities/entities.module';
import { UtilsService } from './utils.service';

@Global()
@Module({
    imports: [HttpModule,
        JwtModule.registerAsync({
            imports: [ConfigModule],
            useFactory: async (ConfigService: ConfigService) => ({
              secret: ConfigService.get('AUTH_JWT'),
              signOptions: { expiresIn: ConfigService.get('AUTH_JWT_EXPIRES'), algorithm : 'HS384' },
            }),
            inject: [ConfigService],
          }), EntitiesModule],
    providers: [UtilsService],
    exports : [UtilsService]
})
export class UtilsModule {}
