import { Module } from '@nestjs/common';
import { ProductService } from './product.service';
import { ProductController } from './product.controller';
import { FtpModule } from 'src/ftp/ftp.module';
import { MulterModule } from '@nestjs/platform-express';
import * as multer from 'multer';
import * as crypto from 'crypto';
import * as path from 'path';
import * as fs from 'fs';

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    try {
      // Asegúrate de que el directorio 'tmp' exista
      const dir = './tmp';
      if (!fs.existsSync(dir)) {
        fs.mkdirSync(dir);
      }
      cb(null, dir);
    } catch (error) {
      console.log(error);
      cb(null, './tmp');
    }
  },
  filename: (req, file, cb) => {
    const hash = crypto.createHash('sha256').update(file.originalname + Date.now()).digest('hex');
    const extension = path.extname(file.originalname);
    cb(null, hash + extension);
  }
})

@Module({
  imports: [
    FtpModule,
    MulterModule.register({
      storage
    })
  ],
  controllers: [ProductController],
  providers: [ProductService],
})
export class ProductModule {}
