import { Type } from "class-transformer";
import { IsArray, IsNumber, ValidateNested } from "class-validator";

class ImagesPosition {
    @IsNumber()
    id: number;

    @IsNumber()
    position: number;
}

export class DtoUpdatePositionImages {
    @IsArray()
    @ValidateNested()
    @Type(() => ImagesPosition)
    images_position: ImagesPosition[];
}