import { IsNumberString, IsOptional, IsString } from "class-validator";

export class DtoQueryFilters {

    @IsOptional()
    @IsString()
    search?: string; // Nombre

    @IsOptional()
    @IsNumberString()
    min_price?: number;

    @IsOptional()
    @IsNumberString()
    max_price?: number;

    @IsOptional()
    @IsNumberString()
    online?: number;

    @IsOptional()
    @IsString()
    category?: string;

    @IsOptional()
    @IsNumberString()
    type_id?: number;

    @IsNumberString()
    page: number;

    @IsNumberString()
    limit: number;

    @IsOptional()
    @IsString()
    order: string;
}