import { IsArray, IsNumber, IsString } from "class-validator";

export class DtoCreateProduct {

    @IsString()
    name: string;

    @IsString()
    description: string;

    @IsNumber({ maxDecimalPlaces: 2 })
    price: number;

    @IsArray()
    categories: number[];

    @IsNumber()
    type_id: number;

}