import { Inject, Injectable } from '@nestjs/common';
import { ConfigService } from '@nestjs/config';
import { InjectRepository } from '@nestjs/typeorm';
import { Customers } from 'src/entities/customers.entity';
import { Users } from 'src/entities/users.entity';
import Stripe from 'stripe';
import { FindOptionsSelect, Repository } from 'typeorm';
import { UtilsService } from '../../utils/utils.service';
import { Products } from 'src/entities/products.entity';
import { Cart } from 'src/entities/cart.entity';

@Injectable()
export class PaymentsGatewayService {

  private Stripe = new Stripe(process.env.STRIPE_SECRET_KEY, {
    apiVersion: '2025-03-31.basil'
  });

  constructor(
    private readonly ConfigService: ConfigService,
    private readonly UtilsService: UtilsService,
    @InjectRepository(Customers) private readonly CustomersRepository: Repository<Customers>,
    @InjectRepository(Products) private readonly ProductsRepository: Repository<Products>,
    @InjectRepository(Cart) private readonly CartRepository: Repository<Cart>,
  ) { }

  async validCustomer(user: Users) {
    try {
      const customer = this.getCustomer(user);
      if(!customer) {
        return false;
      }
      return true;
    } catch (error) {
      return false;
    }
  }

  /**
   * Crea "cliente" en Stripe
   * @param user 
   * @returns 
   */
  async getCustomer(user: Users) {
    try {

      const customer = await this.CustomersRepository.findOne({ where: { user_id: user.id }, select: { id: true, customer_id: true } });

      if (customer) {
        return customer
      }

      const created_customer = await this.Stripe.customers.create({ email: user.email, name: user.name });

      if (!created_customer) {
        return null;
      }

      const created = await this.CustomersRepository.save({ user_id: user.id, customer_id: created_customer.id })

      if (!created) {
        return null;
      }
      return { id: created.id, customer_id: created.customer_id };
    } catch (error) {
      return null;
    }
  }

  /**
   * 
   * @param products 
   * @returns 
   */
  async createCheckoutSession(user: Users) {
    try {

      console.log(user, ' userr');
      const customer = await this.getCustomer(user);

      if (!customer) {
        this.UtilsService.setHttpCause('ERR_CUSTOMER_NOT_EXIST');
        return null;
      }

      const cart = await this.CartRepository.findOne({ where: { user_id: user.id, active: 1 } })

      const select: FindOptionsSelect<Products> = {
        id: true,
        name: true,
        price: true,
        item: { quantity: true, product_id: true }
      }

      const products = await this.ProductsRepository.find({ where: { item: { cart: { id: cart.id } }, online: 1 }, select, relations: { item: true } });


      const items: Stripe.Checkout.SessionCreateParams.LineItem[] = [];

      products.forEach(product => {
        items.push({
          price_data: {
            currency: 'MXN',
            product_data: {
              name: product.name,
            },
            unit_amount: product.price * 100,
          },
          quantity: product.item.quantity,
        })
      })

      // const session = await this.Stripe.paymentIntents.create({
      //   amount: 100 * 100,
      //   currency: 'MXN',
      //   automatic_payment_methods: { enabled: true }
      // })

      const session = await this.Stripe.checkout.sessions.create({
        customer: customer.customer_id,
        payment_method_types: ['card'],
        mode: 'payment',
        line_items: items,
        ui_mode: 'embedded',
        return_url: 'http://localhost:40000/sucess',
        // success_url: 'https://example.com/success',
        // cancel_url: 'https://example.com/cancel',
      });


      // return {
      //   id: session.id,
      //   url: session.url,
      //   currency: session.currency,
      //   amount: session.amount_total,
      // };

      return session;


    } catch (error) {
      console.log(error, ' error');
      return null;
    }
  }
}
