import { Body, Controller, Get, Post, UseGuards } from '@nestjs/common';
import { PaymentsGatewayService } from './payments-gateway.service';
import { Users } from 'src/entities/users.entity';
import { UserAuthorization } from 'src/decorators/user_authorization.decorator';
import { UserAuthorizationGuard } from 'src/guards/auth/user_authorization.guard';
import { UtilsService } from '../../utils/utils.service';

@Controller('payments-gateway')
export class PaymentsGatewayController {
  constructor(private readonly PaymentsGatewayService: PaymentsGatewayService, private readonly UtilsService: UtilsService) {}

  @UseGuards(UserAuthorizationGuard)
  @Get('/customer')
  async validCustomer(@UserAuthorization() user: Users) {
    const response = await this.PaymentsGatewayService.validCustomer(user);

    if(response) {
      this.UtilsService.response(200);
    } else {
      this.UtilsService.response(404);
    }

  }

  @UseGuards(UserAuthorizationGuard)
  @Post('/checkout_session')
  async createCheckout(@UserAuthorization() user: Users) {
    const session = await this.PaymentsGatewayService.createCheckoutSession(user);

    if(session) {
      return session;
    } else {
      this.UtilsService.response(400);
    }

  }

}
