import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { IndexCategories } from 'src/entities/index_categories.entity';
import { Repository } from 'typeorm';
import { DtoCreateCategory } from './dto/create_category.dto';
import { DtoFiltersCategories } from './dto/filters_categories.dto';

@Injectable()
export class CategoriesService {

    constructor(
        @InjectRepository(IndexCategories) private readonly IndexCategoriesRepository: Repository<IndexCategories>,
    ) {}

    async findAll(filters: DtoFiltersCategories) {
        try {
            return await this.IndexCategoriesRepository.find({where: filters});
        } catch (error) {
            return [];
        }
    }

    async create(data: DtoCreateCategory) {
        try {
            const created = await this.IndexCategoriesRepository.save(data);

            if(created) {
                return created;
            } else {
                return null;
            }
        } catch (error) {
            return null;
        }
    }

}
