import { Body, Controller, Get, Post, Query, UseGuards } from '@nestjs/common';
import { CategoriesService } from './categories.service';
import { DtoCreateCategory } from './dto/create_category.dto';
import { UtilsService } from '../../utils/utils.service';
import { UserAuthorizationGuard } from 'src/guards/auth/user_authorization.guard';
import { UserAuthorization } from 'src/decorators/user_authorization.decorator';
import { UserAdminAuthorizationGuard } from 'src/guards/auth_admin/user_admin_authorization.guard';
import { DtoFiltersCategories } from './dto/filters_categories.dto';

@Controller('categories')
export class CategoriesController {
  constructor(
    private readonly CategoriesService: CategoriesService,
    private readonly UtilsService: UtilsService,
  ) {}

  @Get()
  async findAll(@Query() filters: DtoFiltersCategories) {
    return await this.CategoriesService.findAll(filters);
  }

  @UseGuards(UserAdminAuthorizationGuard)
  @Post()
  async create(@Body() data: DtoCreateCategory) {

    const response = await this.CategoriesService.create(data);

    if(response) {
      this.UtilsService.response(200)
    } else {
      this.UtilsService.response(400);
    }
  }

}
