import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { ConfigService } from '@nestjs/config/dist'
import * as bodyParser from 'body-parser';
import { ValidationPipe } from '@nestjs/common';


async function bootstrap() {

  const app = await NestFactory.create(AppModule);
  
  app.setGlobalPrefix('api');
  
  app.enableCors({
    origin: '*',
    methods: ['GET', 'POST', 'PUT', 'DELETE']
  });

  const config_service = app.get(ConfigService);

  app.use(bodyParser.json({limit: '10mb'}));

  app.useGlobalPipes(new ValidationPipe({
    whitelist: true,
  }));

  await app.listen(config_service.get('API_PORT'), config_service.get('API_IP'));

  console.log(`Aplicación corriendo en el puerto: ${config_service.get('API_PORT')}`);
}
bootstrap();
