import { MailerService } from '@nestjs-modules/mailer';
import { Injectable } from '@nestjs/common';
import * as Handlebars from 'handlebars';
import { ActivateAccountEmailInterface } from './interfaces/activate_account_email.interface';
import { ConfigService } from '@nestjs/config';
import { SuccessChangePasswordInterface } from './interfaces/success_change_password.interface';

@Injectable()
export class MailService {

    constructor(
        private readonly MailerService: MailerService,
        private readonly ConfigService: ConfigService,
    ) {
        // Registrar el helper al inicializar Handlebars
        Handlebars.registerHelper('currentYear', () => new Date().getFullYear());

        //Nombre estático de la tienda
        Handlebars.registerHelper('name_shop', () => ConfigService.get('NAME_SHOP'));
    }

    async activateAccount(data: ActivateAccountEmailInterface) {
        try {

            const link = this.ConfigService.get('PORTAL_URL');

            await this.MailerService.sendMail({
                to: data.to,
                subject: "Activación de cuenta",
                template: "./activate_account",
                context: {
                    name: data.name,
                    link_activation: link + data.link_activation,
                }
            });
            console.log('Email de activación enviado correctamente');
            return true;
        } catch (error) {
            console.error(error, ' error');
            return false;
        }
    }

    async forgotPassword(data: ActivateAccountEmailInterface) {
        try {

            const link = this.ConfigService.get('ECOMMERCE_LINK');

            await this.MailerService.sendMail({
                to: data.to,
                subject: "Restablece tu contraseña",
                template: "./forgot_password",
                context: {
                    name: data.name,
                    link_activation: link + data.link_activation,
                }
            });
            console.log('Email de olvidé mi contraseña enviado correctamente');
            return true;
        } catch (error) {
            console.error(error, ' error');
            return false;
        }
    }

    async successPasswordChanged(data: SuccessChangePasswordInterface) {
        try {

            const email_support = this.ConfigService.get('EMAIL_SUPPORT');

            await this.MailerService.sendMail({
                to: data.to,
                subject: "Cambio de contraseña exitoso",
                template: "./success_change_password",
                context: {
                    name: data.name,
                    email_support: 'mailto:'+email_support,
                }
            })
            console.log('Email de cambio de contraseña enviado correctamente');
            return true;
        } catch (error) {
            console.error(error, ' error');
            return false;
        }
    }
}
