import { ExceptionFilter, Catch, ArgumentsHost } from '@nestjs/common';
import { Response } from 'express';

@Catch()
export class HttpResponse implements ExceptionFilter {

    constructor() {

    } 
    catch(err: any, host: ArgumentsHost) {

        const ctx = host.switchToHttp();
        const response = ctx.getResponse<Response>();
        const bodyResponse: any = {};
        let status = 500;



        try {

            if (typeof err.getStatus === "function") {

            
                status = err.getStatus();




                if (err.response.status) {
                    bodyResponse.status = err.response.status;
                } else {
                    bodyResponse.status = status;

                }

                if (err.response.message) {

                    if (Array.isArray(err.response.message)) {
                        bodyResponse.cause = err.response.message
                        bodyResponse.message = "";

                    }else{
                        bodyResponse.message = err.response.message;

                    }


                }

                if (err.response.error) {
                    bodyResponse.error = err.response.error;
                }

                if (err.response.cause) {
                    bodyResponse.cause = err.response.cause;
                }



                if (err.response.custom) {

                    delete err.response.custom;

                    

                    response.status(status).json(err.response);

                } else {
                    response.status(status).json(bodyResponse);

                }

            } else {
                console.log(err)

                response.status(500).json({
                    "status": 500,
                    "message": "No se logro procesar la solicitud",
                    "error": "Error Interno del Servidor"
                });
            }


        } catch (err) {
            console.log(err)
            response.status(500).json({
                "status": 500,
                "message": "No se logro procesar la solicitud",
                "error": "Error Interno del Servidor"
            });
        }
    }
}