import { Injectable } from "@nestjs/common";
import { PassportStrategy } from "@nestjs/passport";
import { ExtractJwt, Strategy } from "passport-jwt";
import { ConfigService } from '@nestjs/config';
import { InjectRepository } from "@nestjs/typeorm";
import { Users } from "src/entities/users.entity";
import { Repository } from "typeorm";
import { AdminUsers } from "src/entities/admin_users.entity";

@Injectable()
export class UsersAdminAuthorizationStrategy extends PassportStrategy(Strategy, 'AuthGuardAdminAuthorization') {
    constructor(
        private readonly ConfigService: ConfigService,
        @InjectRepository(AdminUsers) private readonly UsersAdminRepository: Repository<AdminUsers>,
    ) {
        super({
            jwtFromRequest: ExtractJwt.fromAuthHeaderAsBearerToken(),
            ignoreExpiration: false,
            secretOrKey: ConfigService.get('AUTH_ADMIN_JWT')
        })
    }

    async validate(payload: any) {
        const user = await this.UsersAdminRepository.findOne({where: {id: payload.id}});
        return user;
    }
}