import { CanActivate, ExecutionContext, Injectable, UnauthorizedException } from '@nestjs/common';
import { JwtService } from '@nestjs/jwt';
import { ConfigService } from '@nestjs/config';
import { Request } from 'express';
import { UtilsService } from '../../utils/utils.service';
import { AuthGuard } from '@nestjs/passport';

@Injectable()
export class UserAdminAuthorizationGuard extends AuthGuard('AuthGuardAdminAuthorization') {
  constructor(private readonly UtilsService: UtilsService) {
    super()
  }

  handleRequest(err, user) {
    if(err || !user) {
      this.UtilsService.response(401);
    }
    return user;
  }

}
