import { Injectable } from "@nestjs/common";
import { PassportStrategy } from "@nestjs/passport";
import { ExtractJwt, Strategy } from "passport-jwt";
import { ConfigService } from '@nestjs/config';
import { InjectRepository } from "@nestjs/typeorm";
import { Users } from "src/entities/users.entity";
import { Repository } from "typeorm";

@Injectable()
export class UsersAuthorizationStrategy extends PassportStrategy(Strategy, 'AuthGuardAuthorization') {
    constructor(
        private readonly ConfigService: ConfigService,
        @InjectRepository(Users) private readonly UsersRepository: Repository<Users>,
    ) {
        super({
            jwtFromRequest: ExtractJwt.fromAuthHeaderAsBearerToken(),
            ignoreExpiration: false,
            secretOrKey: ConfigService.get('AUTH_JWT')
        })
    }

    async validate(payload: any) {
        const user = await this.UsersRepository.findOne({where: {id: payload.id}, select: {id: true, name: true, email: true, is_active: true, cellphone: true,}});
        return user;
    }
}