import { Injectable } from '@nestjs/common';
import { UtilsService } from '../../utils/utils.service';
import { AuthGuard } from '@nestjs/passport';

@Injectable()
export class UserAuthorizationGuard extends AuthGuard('AuthGuardAuthorization') {
  constructor(private readonly UtilsService: UtilsService) {
    super()
  }

  handleRequest(err, user) {
    if(err || !user) {
      this.UtilsService.response(401);
    }
    return user;
  }

}
