import { Injectable } from '@nestjs/common';
import { AccessOptions, Client } from 'basic-ftp';

@Injectable()
export class FtpService {

    private Client: Client;

    constructor() {}

    async connect(config: AccessOptions) {
        try {
            this.Client = new Client;
            await this.Client.access(config);
            console.log('Conexión FTP establecida');
        } catch (error) {
            console.error(error, ' FTP_SERVICE');
            throw new Error('No se pudo conectar al servidor FTP');
        }
    }

    async uploadFile(local_path: string, remote_path: string, remote_path_without_filename: string) {
        try {
            await this.Client.ensureDir('/static' + remote_path_without_filename);
            await this.Client.uploadFrom(local_path, '/static/'+remote_path);
            console.log(`Archivo subido exitosamente a ${remote_path}`);
        } catch (error) {
            console.error(error, ' UPLOAD_FILE_FTP_SERVICE');
            throw new Error('Hubo un error en UPLOAD_FILE');
        }
    }

    async disconnect() {
        await this.Client.close();
        console.log('Conexión FTP terminada.');
    }

}
