import { Column, Entity, OneToMany, OneToOne, PrimaryGeneratedColumn } from "typeorm";
import { Cart } from "./cart.entity";
import { Customers } from "./customers.entity";

@Entity('users')
export class Users {
    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    name: string;

    @Column({ unique: true })
    email: string;

    @Column({ select: false })
    password: string;

    @Column({ default: 0, select: false })
    is_active: number;

    @Column()
    cellphone: string;

    @OneToMany(() => Cart, Cart => Cart.user)
    carts: Cart[];

    @OneToOne(() => Customers, Customers => Customers.user)
    customer: Customers;
}