import { Column, Entity, JoinColumn, ManyToOne, PrimaryGeneratedColumn } from "typeorm";
import { Products } from "./products.entity";

@Entity('products_photos')
export class ProductsPhotos {

    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    product_id: number;

    @Column()
    title: string;

    @Column()
    position: number;

    @Column()
    small_size_url: string;

    @Column()
    full_size_url: string;

    @ManyToOne(() => Products, Products => Products.photos)
    @JoinColumn({name: 'product_id'})
    product: Products;

}