import { Column, Entity, JoinColumn, ManyToOne, PrimaryGeneratedColumn } from "typeorm";
import { Products } from "./products.entity";
import { IndexCategories } from "./index_categories.entity";

@Entity('products_categories')
export class ProductsCategories {

    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    product_id: number;

    @Column()
    category_id: number;

    @ManyToOne(() => Products, Products => Products.products_categories)
    @JoinColumn({name: 'product_id'})
    product: Products;

    @ManyToOne(() => IndexCategories, IndexCategories => IndexCategories.products_categories)
    @JoinColumn({name: 'category_id'})
    categories: IndexCategories;

}