import { Column, Entity, JoinColumn, OneToMany, OneToOne, PrimaryGeneratedColumn } from "typeorm";
import { IndexCategories } from "./index_categories.entity";
import { IndexProductType } from "./index_product_type.entity";
import { ProductsPhotos } from "./products_photos.entity";
import { ProductsCategories } from './products_categories.entity';
import { CartItems } from "./cart_items.entity";

@Entity('products')
export class Products {

    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    name: string;

    @Column({ type: 'longtext'})
    description: string;

    @Column({ type: 'decimal' })
    price: number;

    @Column()
    online: number;

    @Column()
    type_id: number;

    @Column()
    created_at: Date;

    @Column()
    updated_at: Date;

    @OneToOne(() => IndexProductType, IndexProductType => IndexProductType.product)
    @JoinColumn({name: 'type_id'})
    type: IndexProductType;

    @OneToMany(() => ProductsPhotos, ProductsPhotos => ProductsPhotos.product)
    photos: ProductsPhotos[];

    @OneToMany(() => ProductsCategories, ProductsCategories => ProductsCategories.product)
    products_categories: ProductsCategories[];

    @OneToOne(() => CartItems, CartItems => CartItems.product)
    item: CartItems;
}