import { Global, Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Users } from './users.entity';
import { AdminUsers } from './admin_users.entity';
import { AdminUsersRoles } from './admin_users_roles.entity';
import { IndexCategories } from './index_categories.entity';
import { IndexProductType } from './index_product_type.entity';
import { Products } from './products.entity';
import { ProductsPhotos } from './products_photos.entity';
import { ProductsCategories } from './products_categories.entity';
import { Cart } from './cart.entity';
import { CartItems } from './cart_items.entity';
import { Customers } from './customers.entity';

@Global()
@Module({
    imports: [
        TypeOrmModule.forFeature([
            Users,
            AdminUsers,
            AdminUsersRoles,
            IndexCategories,
            IndexProductType,
            Products,
            ProductsPhotos,
            ProductsCategories,
            Cart,
            CartItems,
            Customers,
        ])
    ],
    exports: [TypeOrmModule]
})
export class EntitiesModule {}
