import { Column, Entity, JoinColumn, OneToOne, PrimaryGeneratedColumn } from "typeorm";
import { Users } from "./users.entity";

@Entity('customers')
export class Customers {
    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    user_id: number;

    @Column()
    customer_id: string;

    @OneToOne(() => Users, Users => Users.customer)
    @JoinColumn({name: 'user_id'})
    user: Users;

}