import { Column, Entity, JoinColumn, ManyToOne, OneToOne, PrimaryGeneratedColumn } from "typeorm";
import { Cart } from "./cart.entity";
import { Products } from "./products.entity";

@Entity('cart_items')
export class CartItems {

    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    cart_id: number;

    @Column()
    product_id: number;

    @Column()
    quantity: number;

    @Column()
    created_at: Date;

    @ManyToOne(() => Cart, Cart => Cart.items, { onDelete: 'CASCADE' })
    @JoinColumn({name: 'cart_id'})
    cart: Cart;

    @OneToOne(() => Products, Products => Products.item)
    @JoinColumn({name: 'product_id'})
    product: Products;


}