import { Column, Entity, JoinColumn, ManyToOne, OneToMany, PrimaryGeneratedColumn } from "typeorm";
import { Users } from "./users.entity";
import { CartItems } from "./cart_items.entity";
import { IsIn } from "class-validator";

@Entity('cart')
export class Cart {

    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    user_id: number;

    @Column({ type: 'tinyint', width: 1, default: 0 })
    @IsIn([0, 1], { message: 'El active debe ser 0 o 1' })
    active: number;

    @Column({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' })
    created_at: Date;

    @ManyToOne(() => Users, Users => Users.carts)
    @JoinColumn({name: 'user_id'})
    user: Users;

    @OneToMany(() => CartItems, CartItems => CartItems.cart, {eager: true})
    items: CartItems[];

}