import { Column, Entity, JoinColumn, OneToOne, PrimaryGeneratedColumn } from "typeorm";
import { AdminUsersRoles } from "./admin_users_roles.entity";

@Entity('admin_users')
export class AdminUsers {

    @PrimaryGeneratedColumn()
    id: number;

    @Column()
    name: string;

    @Column()
    email: string;

    @Column({ select: false })
    password: string;

    @Column()
    role_id: number;

    @Column({ select: false })
    created_at: Date;

    @OneToOne(() => AdminUsersRoles, AdminUsersRoles => AdminUsersRoles.admin_user)
    @JoinColumn({name: 'role_id'})
    role: AdminUsersRoles;

}