import { createParamDecorator, ExecutionContext, SetMetadata } from '@nestjs/common';

export const UserAuthorization = createParamDecorator(
    (data: string | undefined, ctx: ExecutionContext) => {
        const request = ctx.switchToHttp().getRequest();
        const user = request.user;
        return data ? user?.[data] : user;
    }
)
