import { Module } from '@nestjs/common';
import { AuthAdminService } from './auth_admin.service';
import { AuthAdminController } from './auth_admin.controller';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { PassportModule } from '@nestjs/passport';
import { EntitiesModule } from 'src/entities/entities.module';
import { JwtModule } from '@nestjs/jwt';
import { UsersAdminAuthorizationStrategy } from 'src/guards/auth_admin/user_admin_authorization.strategy';

@Module({
    imports: [
      ConfigModule,
      PassportModule,
      EntitiesModule,
      JwtModule.registerAsync({
        imports: [ConfigModule],
        useFactory: async (ConfigService: ConfigService) => ({
          secret: ConfigService.get('AUTH_ADMIN_JWT'),
          signOptions: { expiresIn: ConfigService.get('AUTH_ADMIN_JWT_EXPIRES'), algorithm : 'HS384' },
        }),
        inject: [ConfigService],
      })
    ],
  controllers: [AuthAdminController],
  providers: [AuthAdminService, UsersAdminAuthorizationStrategy],
})
export class AuthAdminModule {}
