import { Body, Controller, Post } from '@nestjs/common';
import { AuthAdminService } from './auth_admin.service';
import { DtoCreateAdminUser } from 'src/auth/dto/create_admin_user.dto';
import { DtoLoginUserAdmin } from 'src/auth/dto/login_user_admin.dto';

@Controller('auth-admin')
export class AuthAdminController {
  constructor(private readonly AuthAdminService: AuthAdminService) {}

  @Post('/register')
  async registerAdmin(@Body() data: DtoCreateAdminUser) {
    return await this.AuthAdminService.createAdminUser(data);
  }

  @Post('/login')
  async loginAdmin(@Body() data: DtoLoginUserAdmin) {
    return await this.AuthAdminService.loginAdmin(data);
  }

  @Post('/token')
  async refreshAccessToken(@Body('refresh_token') refresh_token: string) {
    return await this.AuthAdminService.generateRefreshAccessToken(refresh_token);
  }
}
