import { IsEmail, IsNumber, IsOptional, IsString, MinLength } from "class-validator";

export class DtoCreateAdminUser {

    @IsString()
    name: string;

    @IsEmail()
    email: string;

    @MinLength(8)
    @IsString()
    password: string;

    @IsOptional()
    @IsNumber()
    role_id: number;

}