import { Global, Module } from '@nestjs/common';
import { AuthService } from './auth.service';
import { AuthController } from './auth.controller';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { PassportModule } from '@nestjs/passport';
import { EntitiesModule } from 'src/entities/entities.module';
import { JwtModule } from '@nestjs/jwt';
import { MailService } from 'src/mail/mail.service';
import { UsersAuthorizationStrategy } from 'src/guards/auth/user_authorization.strategy';
import { CartService } from 'src/modules/cart/cart.service';

@Global()
@Module({
  imports: [
    ConfigModule,
    PassportModule,
    EntitiesModule,
    JwtModule.registerAsync({
      imports: [ConfigModule],
      useFactory: async (ConfigService: ConfigService) => ({
        secret: ConfigService.get('AUTH_JWT'),
        signOptions: { expiresIn: ConfigService.get('AUTH_JWT_EXPIRES'), algorithm : 'HS384' },
      }),
      inject: [ConfigService],
    })
  ],
  controllers: [AuthController],
  providers: [AuthService, MailService, UsersAuthorizationStrategy, CartService],
})
export class AuthModule {}
