import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { TypeOrmModule } from '@nestjs/typeorm';
import { EntitiesModule } from './entities/entities.module';
import { AuthModule } from './auth/auth.module';
import { UtilsModule } from './utils/utils.module';
import { APP_FILTER } from '@nestjs/core';
import { HttpResponse } from './interceptor/http/httpResponse.interceptor';
import { MailModule } from './mail/mail.module';
import { ModulesModule } from './modules/modules.module';
import { AuthAdminModule } from './auth_admin/auth_admin.module';
import { FtpModule } from './ftp/ftp.module';

@Module({
  imports: [
    ConfigModule.forRoot({envFilePath: process.env.NODE_ENV ? `.${process.env.NODE_ENV}.env` : '.development.env', isGlobal: true, expandVariables: true}),
    TypeOrmModule.forRootAsync({
      imports: [ConfigModule],
      useFactory: (ConfigService: ConfigService) => ({
        // logging: true,
        type: 'mysql',
        host: ConfigService.get('DB_HOST'),
        port: ConfigService.get('DB_PORT'),
        username: ConfigService.get('DB_USERNAME'),
        password: ConfigService.get('DB_PASSWORD'),
        database: ConfigService.get('DB_DATABASE'),
        autoLoadEntities: true,
        // synchronize: false,
        timezone: 'Z',
      }),
      inject: [ConfigService]
    }),
    AuthModule,
    UtilsModule,
    EntitiesModule,
    MailModule,
    ModulesModule,
    AuthAdminModule,
    FtpModule,    
  ],
  controllers: [AppController],
  exports: [ConfigModule],
  providers: [
    {
      provide: APP_FILTER,
      useClass: HttpResponse
    }
  ],
})
export class AppModule {}
