import { HttpService } from '@nestjs/axios';
import { ConfigService } from '@nestjs/config';
import { JwtService } from '@nestjs/jwt';
import { RecoveryPayloadInterface } from 'src/interfaces/recovery_payload_jwt.interface';
import { RegisterPayloadInterface } from 'src/interfaces/register_payload_jwt.interface';
export declare class UtilsService {
    private readonly HttpService;
    private readonly JwtService;
    private readonly ConfigService;
    private http_error_cause;
    constructor(HttpService: HttpService, JwtService: JwtService, ConfigService: ConfigService);
    generatePassword(password: string): {
        password: string;
        hash: string;
    };
    response(code: number, message?: string, cause?: any[]): void;
    customResponse(code: number, content?: any): void;
    setHttpCause(cause: string): void;
    getHttpCause(): string[];
    generateAuthToken(user_id: number): string;
    generateActivateAccountToken(user_id: number): string;
    generateForgotPasswordToken(user_id: number): string;
    verifyAuthToken(token: string): {
        payload: any;
        error: string;
        expired: boolean;
    };
    verifyActivateAccount(token: string): {
        payload: RegisterPayloadInterface;
        error: string;
        expired: boolean;
    };
    verifyForgotPasswordToken(token: string): {
        payload: RecoveryPayloadInterface;
        error: string;
        expired: boolean;
    };
    getFtpAccess(): {
        host: any;
        user: any;
        password: any;
    };
}
