import { UtilsService } from '../../utils/utils.service';
import { DtoCreateProduct } from './dto/create_product.dto';
import { Products } from 'src/entities/products.entity';
import { DataSource, Repository } from 'typeorm';
import { Users } from 'src/entities/users.entity';
import { FtpService } from '../../ftp/ftp.service';
import { ProductsPhotos } from 'src/entities/products_photos.entity';
import { DtoUploadImage } from './dto/upload_image.dto';
import { ConfigService } from '@nestjs/config';
import { DtoQueryFilters } from './dto/query_filters.dto';
import { ProductsCategories } from 'src/entities/products_categories.entity';
import { DtoUpdatePositionImages } from './dto/update_position_images.dto';
import { DtoUpdateProduct } from './dto/update_product.dto';
import { IndexCategories } from 'src/entities/index_categories.entity';
import { CartItems } from 'src/entities/cart_items.entity';
import { Cart } from 'src/entities/cart.entity';
export declare class ProductService {
    private readonly UtilsService;
    private readonly FtpService;
    private readonly ConfigService;
    private readonly ProductsRepository;
    private readonly ProductsPhotosRepository;
    private readonly ProductsCategoriesRepository;
    private readonly IndexCategoriesRepository;
    private readonly CartItemsRepository;
    private readonly CartRepository;
    private readonly DataSource;
    constructor(UtilsService: UtilsService, FtpService: FtpService, ConfigService: ConfigService, ProductsRepository: Repository<Products>, ProductsPhotosRepository: Repository<ProductsPhotos>, ProductsCategoriesRepository: Repository<ProductsCategories>, IndexCategoriesRepository: Repository<IndexCategories>, CartItemsRepository: Repository<CartItems>, CartRepository: Repository<Cart>, DataSource: DataSource);
    findAll(filters: DtoQueryFilters): Promise<{
        products: Products[];
        total: number;
        page: number;
        last_page: number;
    }>;
    findOne(product_id: number, access_token: string): Promise<{
        exist_in_cart: boolean;
        id: number;
        name: string;
        description: string;
        price: number;
        online: number;
        type_id: number;
        created_at: Date;
        updated_at: Date;
        type: import("../../entities/index_product_type.entity").IndexProductType;
        photos: ProductsPhotos[];
        products_categories: ProductsCategories[];
        item: CartItems;
    }>;
    create(product: DtoCreateProduct): Promise<Products>;
    update(product_id: number, product: DtoUpdateProduct): Promise<{
        id: number;
        name: string;
        description: string;
        price: number;
        categories: number[];
        type_id: number;
    } & Products>;
    uploadImageProduct(file: Express.Multer.File, data: DtoUploadImage, user: Users): Promise<boolean>;
    changeStatusProduct(id: number): Promise<boolean>;
    updatePositionsImages(product_id: number, data: DtoUpdatePositionImages): Promise<boolean>;
    deleteImage(product_id: number, image_id: number): Promise<boolean>;
    private deleteProduct;
}
