"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductController = void 0;
const common_1 = require("@nestjs/common");
const product_service_1 = require("./product.service");
const user_admin_authorization_guard_1 = require("../../guards/auth_admin/user_admin_authorization.guard");
const create_product_dto_1 = require("./dto/create_product.dto");
const utils_service_1 = require("../../utils/utils.service");
const platform_express_1 = require("@nestjs/platform-express");
const user_authorization_decorator_1 = require("../../decorators/user_authorization.decorator");
const users_entity_1 = require("../../entities/users.entity");
const upload_image_dto_1 = require("./dto/upload_image.dto");
const query_filters_dto_1 = require("./dto/query_filters.dto");
const update_position_images_dto_1 = require("./dto/update_position_images.dto");
const update_product_dto_1 = require("./dto/update_product.dto");
let ProductController = class ProductController {
    constructor(ProductService, UtilsService) {
        this.ProductService = ProductService;
        this.UtilsService = UtilsService;
    }
    async findAll(filters) {
        return await this.ProductService.findAll(filters);
    }
    async findOne(product_id, req) {
        return await this.ProductService.findOne(product_id, req.headers['authorization']);
    }
    async createProduct(product) {
        const response = await this.ProductService.create(product);
        if (response) {
            return response;
        }
        else {
            this.UtilsService.response(200);
        }
    }
    async updateProduct(id, product) {
        const response = await this.ProductService.update(id, product);
        if (response) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async changeStatusProduct(id) {
        const response = await this.ProductService.changeStatusProduct(id);
        if (response) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async uploadImagesProduct(data, file, user) {
        if (!file || !file.path) {
            this.UtilsService.response(400);
        }
        const uploaded = await this.ProductService.uploadImageProduct(file, data, user);
        if (uploaded) {
            this.UtilsService.response(201);
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async changeCurrentPositionImages(product_id, data) {
        const response = await this.ProductService.updatePositionsImages(product_id, data);
        if (response) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async deleteImage(product_id, image_id) {
        const response = await this.ProductService.deleteImage(product_id, image_id);
        if (response) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(400);
        }
    }
};
exports.ProductController = ProductController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [query_filters_dto_1.DtoQueryFilters]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('/:product_id'),
    __param(0, (0, common_1.Param)('product_id')),
    __param(1, (0, common_1.Request)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Object]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "findOne", null);
__decorate([
    (0, common_1.UseGuards)(user_admin_authorization_guard_1.UserAdminAuthorizationGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_product_dto_1.DtoCreateProduct]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "createProduct", null);
__decorate([
    (0, common_1.UseGuards)(user_admin_authorization_guard_1.UserAdminAuthorizationGuard),
    (0, common_1.Put)('/:id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_product_dto_1.DtoUpdateProduct]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "updateProduct", null);
__decorate([
    (0, common_1.UseGuards)(user_admin_authorization_guard_1.UserAdminAuthorizationGuard),
    (0, common_1.Put)('status/:id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "changeStatusProduct", null);
__decorate([
    (0, common_1.UseGuards)(user_admin_authorization_guard_1.UserAdminAuthorizationGuard),
    (0, common_1.Post)('/upload'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.UploadedFile)()),
    __param(2, (0, user_authorization_decorator_1.UserAuthorization)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [upload_image_dto_1.DtoUploadImage, Object, users_entity_1.Users]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "uploadImagesProduct", null);
__decorate([
    (0, common_1.UseGuards)(user_admin_authorization_guard_1.UserAdminAuthorizationGuard),
    (0, common_1.Put)('/position/:id'),
    __param(0, (0, common_1.Param)('id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_position_images_dto_1.DtoUpdatePositionImages]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "changeCurrentPositionImages", null);
__decorate([
    (0, common_1.UseGuards)(user_admin_authorization_guard_1.UserAdminAuthorizationGuard),
    (0, common_1.Delete)('/images/:product_id/:image_id'),
    __param(0, (0, common_1.Param)('product_id', common_1.ParseIntPipe)),
    __param(1, (0, common_1.Param)('image_id', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, Number]),
    __metadata("design:returntype", Promise)
], ProductController.prototype, "deleteImage", null);
exports.ProductController = ProductController = __decorate([
    (0, common_1.Controller)('product'),
    __metadata("design:paramtypes", [product_service_1.ProductService,
        utils_service_1.UtilsService])
], ProductController);
//# sourceMappingURL=product.controller.js.map