import { ProductService } from './product.service';
import { DtoCreateProduct } from './dto/create_product.dto';
import { UtilsService } from '../../utils/utils.service';
import { Users } from 'src/entities/users.entity';
import { DtoUploadImage } from './dto/upload_image.dto';
import { DtoQueryFilters } from './dto/query_filters.dto';
import { DtoUpdatePositionImages } from './dto/update_position_images.dto';
import { DtoUpdateProduct } from './dto/update_product.dto';
export declare class ProductController {
    private readonly ProductService;
    private readonly UtilsService;
    constructor(ProductService: ProductService, UtilsService: UtilsService);
    findAll(filters: DtoQueryFilters): Promise<{
        products: import("../../entities/products.entity").Products[];
        total: number;
        page: number;
        last_page: number;
    }>;
    findOne(product_id: number, req: Request): Promise<{
        exist_in_cart: boolean;
        id: number;
        name: string;
        description: string;
        price: number;
        online: number;
        type_id: number;
        created_at: Date;
        updated_at: Date;
        type: import("../../entities/index_product_type.entity").IndexProductType;
        photos: import("../../entities/products_photos.entity").ProductsPhotos[];
        products_categories: import("../../entities/products_categories.entity").ProductsCategories[];
        item: import("../../entities/cart_items.entity").CartItems;
    }>;
    createProduct(product: DtoCreateProduct): Promise<import("../../entities/products.entity").Products>;
    updateProduct(id: number, product: DtoUpdateProduct): Promise<void>;
    changeStatusProduct(id: number): Promise<void>;
    uploadImagesProduct(data: DtoUploadImage, file: Express.Multer.File, user: Users): Promise<void>;
    changeCurrentPositionImages(product_id: number, data: DtoUpdatePositionImages): Promise<void>;
    deleteImage(product_id: number, image_id: number): Promise<void>;
}
