import { ConfigService } from '@nestjs/config';
import { Customers } from 'src/entities/customers.entity';
import { Users } from 'src/entities/users.entity';
import Stripe from 'stripe';
import { Repository } from 'typeorm';
import { UtilsService } from '../../utils/utils.service';
import { Products } from 'src/entities/products.entity';
import { Cart } from 'src/entities/cart.entity';
export declare class PaymentsGatewayService {
    private readonly ConfigService;
    private readonly UtilsService;
    private readonly CustomersRepository;
    private readonly ProductsRepository;
    private readonly CartRepository;
    private Stripe;
    constructor(ConfigService: ConfigService, UtilsService: UtilsService, CustomersRepository: Repository<Customers>, ProductsRepository: Repository<Products>, CartRepository: Repository<Cart>);
    validCustomer(user: Users): Promise<boolean>;
    getCustomer(user: Users): Promise<Customers | {
        id: number;
        customer_id: string;
    }>;
    createCheckoutSession(user: Users): Promise<Stripe.Response<Stripe.Checkout.Session>>;
}
