"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentsGatewayController = void 0;
const common_1 = require("@nestjs/common");
const payments_gateway_service_1 = require("./payments-gateway.service");
const users_entity_1 = require("../../entities/users.entity");
const user_authorization_decorator_1 = require("../../decorators/user_authorization.decorator");
const user_authorization_guard_1 = require("../../guards/auth/user_authorization.guard");
const utils_service_1 = require("../../utils/utils.service");
let PaymentsGatewayController = class PaymentsGatewayController {
    constructor(PaymentsGatewayService, UtilsService) {
        this.PaymentsGatewayService = PaymentsGatewayService;
        this.UtilsService = UtilsService;
    }
    async validCustomer(user) {
        const response = await this.PaymentsGatewayService.validCustomer(user);
        if (response) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(404);
        }
    }
    async createCheckout(user) {
        const session = await this.PaymentsGatewayService.createCheckoutSession(user);
        if (session) {
            return session;
        }
        else {
            this.UtilsService.response(400);
        }
    }
};
exports.PaymentsGatewayController = PaymentsGatewayController;
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Get)('/customer'),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users]),
    __metadata("design:returntype", Promise)
], PaymentsGatewayController.prototype, "validCustomer", null);
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Post)('/checkout_session'),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users]),
    __metadata("design:returntype", Promise)
], PaymentsGatewayController.prototype, "createCheckout", null);
exports.PaymentsGatewayController = PaymentsGatewayController = __decorate([
    (0, common_1.Controller)('payments-gateway'),
    __metadata("design:paramtypes", [payments_gateway_service_1.PaymentsGatewayService, utils_service_1.UtilsService])
], PaymentsGatewayController);
//# sourceMappingURL=payments-gateway.controller.js.map