"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoriesController = void 0;
const common_1 = require("@nestjs/common");
const categories_service_1 = require("./categories.service");
const create_category_dto_1 = require("./dto/create_category.dto");
const utils_service_1 = require("../../utils/utils.service");
const user_admin_authorization_guard_1 = require("../../guards/auth_admin/user_admin_authorization.guard");
const filters_categories_dto_1 = require("./dto/filters_categories.dto");
let CategoriesController = class CategoriesController {
    constructor(CategoriesService, UtilsService) {
        this.CategoriesService = CategoriesService;
        this.UtilsService = UtilsService;
    }
    async findAll(filters) {
        return await this.CategoriesService.findAll(filters);
    }
    async create(data) {
        const response = await this.CategoriesService.create(data);
        if (response) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(400);
        }
    }
};
exports.CategoriesController = CategoriesController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [filters_categories_dto_1.DtoFiltersCategories]),
    __metadata("design:returntype", Promise)
], CategoriesController.prototype, "findAll", null);
__decorate([
    (0, common_1.UseGuards)(user_admin_authorization_guard_1.UserAdminAuthorizationGuard),
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_category_dto_1.DtoCreateCategory]),
    __metadata("design:returntype", Promise)
], CategoriesController.prototype, "create", null);
exports.CategoriesController = CategoriesController = __decorate([
    (0, common_1.Controller)('categories'),
    __metadata("design:paramtypes", [categories_service_1.CategoriesService,
        utils_service_1.UtilsService])
], CategoriesController);
//# sourceMappingURL=categories.controller.js.map