import { Cart } from 'src/entities/cart.entity';
import { Products } from 'src/entities/products.entity';
import { Users } from 'src/entities/users.entity';
import { Repository } from 'typeorm';
import { DtoAddToCart } from './dto/add_to_cart.dto';
import { CartItems } from 'src/entities/cart_items.entity';
import { UtilsService } from '../../utils/utils.service';
import { ConfigService } from '@nestjs/config';
export declare class CartService {
    private readonly CartRepository;
    private readonly ProductRepository;
    private readonly CartItemsRepository;
    private readonly UtilsService;
    private readonly ConfigService;
    constructor(CartRepository: Repository<Cart>, ProductRepository: Repository<Products>, CartItemsRepository: Repository<CartItems>, UtilsService: UtilsService, ConfigService: ConfigService);
    getCart(user: Users): Promise<{
        id: number;
        price: number;
        quantity: number;
        discount: number;
        items: any[];
    }>;
    addToCart(user: Users, data: DtoAddToCart): Promise<CartItems>;
    removeFromCart(user: Users, item_id: number): Promise<{
        id: number;
        price: number;
        quantity: number;
        discount: number;
        items: any[];
    }>;
    getTotalProductsCart(user: Users): Promise<{
        total: number;
    }>;
}
