"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CartController = void 0;
const common_1 = require("@nestjs/common");
const cart_service_1 = require("./cart.service");
const user_authorization_guard_1 = require("../../guards/auth/user_authorization.guard");
const user_authorization_decorator_1 = require("../../decorators/user_authorization.decorator");
const users_entity_1 = require("../../entities/users.entity");
const add_to_cart_dto_1 = require("./dto/add_to_cart.dto");
const utils_service_1 = require("../../utils/utils.service");
let CartController = class CartController {
    constructor(CartService, UtilsService) {
        this.CartService = CartService;
        this.UtilsService = UtilsService;
    }
    async getCart(user) {
        return this.CartService.getCart(user);
    }
    async addToCart(user, data) {
        const added = await this.CartService.addToCart(user, data);
        if (added) {
            return added;
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async removeFromCart(user, item_id) {
        const removed = await this.CartService.removeFromCart(user, item_id);
        if (removed) {
            return removed;
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async getTotalProductsInCart(user) {
        return await this.CartService.getTotalProductsCart(user);
    }
};
exports.CartController = CartController;
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Get)(),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users]),
    __metadata("design:returntype", Promise)
], CartController.prototype, "getCart", null);
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Post)('/cart_item/add'),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users, add_to_cart_dto_1.DtoAddToCart]),
    __metadata("design:returntype", Promise)
], CartController.prototype, "addToCart", null);
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Delete)('/cart_item/:item_id'),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __param(1, (0, common_1.Param)('item_id', common_1.ParseIntPipe)),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users, Number]),
    __metadata("design:returntype", Promise)
], CartController.prototype, "removeFromCart", null);
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Get)('/total_items'),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users]),
    __metadata("design:returntype", Promise)
], CartController.prototype, "getTotalProductsInCart", null);
exports.CartController = CartController = __decorate([
    (0, common_1.Controller)('cart'),
    __metadata("design:paramtypes", [cart_service_1.CartService, utils_service_1.UtilsService])
], CartController);
//# sourceMappingURL=cart.controller.js.map