import { CartService } from './cart.service';
import { Users } from 'src/entities/users.entity';
import { DtoAddToCart } from './dto/add_to_cart.dto';
import { UtilsService } from '../../utils/utils.service';
export declare class CartController {
    private readonly CartService;
    private readonly UtilsService;
    constructor(CartService: CartService, UtilsService: UtilsService);
    getCart(user: Users): Promise<{
        id: number;
        price: number;
        quantity: number;
        discount: number;
        items: any[];
    }>;
    addToCart(user: Users, data: DtoAddToCart): Promise<import("../../entities/cart_items.entity").CartItems>;
    removeFromCart(user: Users, item_id: number): Promise<{
        id: number;
        price: number;
        quantity: number;
        discount: number;
        items: any[];
    }>;
    getTotalProductsInCart(user: Users): Promise<{
        total: number;
    }>;
}
