"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersAuthorizationStrategy = void 0;
const common_1 = require("@nestjs/common");
const passport_1 = require("@nestjs/passport");
const passport_jwt_1 = require("passport-jwt");
const config_1 = require("@nestjs/config");
const typeorm_1 = require("@nestjs/typeorm");
const users_entity_1 = require("../../entities/users.entity");
const typeorm_2 = require("typeorm");
let UsersAuthorizationStrategy = class UsersAuthorizationStrategy extends (0, passport_1.PassportStrategy)(passport_jwt_1.Strategy, 'AuthGuardAuthorization') {
    constructor(ConfigService, UsersRepository) {
        super({
            jwtFromRequest: passport_jwt_1.ExtractJwt.fromAuthHeaderAsBearerToken(),
            ignoreExpiration: false,
            secretOrKey: ConfigService.get('AUTH_JWT')
        });
        this.ConfigService = ConfigService;
        this.UsersRepository = UsersRepository;
    }
    async validate(payload) {
        const user = await this.UsersRepository.findOne({ where: { id: payload.id }, select: { id: true, name: true, email: true, is_active: true, cellphone: true, } });
        return user;
    }
};
exports.UsersAuthorizationStrategy = UsersAuthorizationStrategy;
exports.UsersAuthorizationStrategy = UsersAuthorizationStrategy = __decorate([
    (0, common_1.Injectable)(),
    __param(1, (0, typeorm_1.InjectRepository)(users_entity_1.Users)),
    __metadata("design:paramtypes", [config_1.ConfigService,
        typeorm_2.Repository])
], UsersAuthorizationStrategy);
//# sourceMappingURL=user_authorization.strategy.js.map