import { DtoCreateAdminUser } from 'src/auth/dto/create_admin_user.dto';
import { DtoLoginUserAdmin } from 'src/auth/dto/login_user_admin.dto';
import { AdminUsers } from 'src/entities/admin_users.entity';
import { UtilsService } from 'src/utils/utils.service';
import { Repository } from 'typeorm';
import { ConfigService } from '@nestjs/config';
import { JwtService } from '@nestjs/jwt';
export declare class AuthAdminService {
    private readonly UtilsService;
    private readonly ConfigService;
    private readonly JwtService;
    private readonly AdminUsersRepository;
    constructor(UtilsService: UtilsService, ConfigService: ConfigService, JwtService: JwtService, AdminUsersRepository: Repository<AdminUsers>);
    createAdminUser(data: DtoCreateAdminUser): Promise<void>;
    loginAdmin(data: DtoLoginUserAdmin): Promise<{
        access_token: string;
        refresh_token: string;
    }>;
    generateRefreshAccessToken(refresh_token: string): Promise<{
        access_token: string;
        refresh_token: string;
    }>;
}
