"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthAdminModule = void 0;
const common_1 = require("@nestjs/common");
const auth_admin_service_1 = require("./auth_admin.service");
const auth_admin_controller_1 = require("./auth_admin.controller");
const config_1 = require("@nestjs/config");
const passport_1 = require("@nestjs/passport");
const entities_module_1 = require("../entities/entities.module");
const jwt_1 = require("@nestjs/jwt");
const user_admin_authorization_strategy_1 = require("../guards/auth_admin/user_admin_authorization.strategy");
let AuthAdminModule = class AuthAdminModule {
};
exports.AuthAdminModule = AuthAdminModule;
exports.AuthAdminModule = AuthAdminModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule,
            passport_1.PassportModule,
            entities_module_1.EntitiesModule,
            jwt_1.JwtModule.registerAsync({
                imports: [config_1.ConfigModule],
                useFactory: async (ConfigService) => ({
                    secret: ConfigService.get('AUTH_ADMIN_JWT'),
                    signOptions: { expiresIn: ConfigService.get('AUTH_ADMIN_JWT_EXPIRES'), algorithm: 'HS384' },
                }),
                inject: [config_1.ConfigService],
            })
        ],
        controllers: [auth_admin_controller_1.AuthAdminController],
        providers: [auth_admin_service_1.AuthAdminService, user_admin_authorization_strategy_1.UsersAdminAuthorizationStrategy],
    })
], AuthAdminModule);
//# sourceMappingURL=auth_admin.module.js.map