"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthAdminController = void 0;
const common_1 = require("@nestjs/common");
const auth_admin_service_1 = require("./auth_admin.service");
const create_admin_user_dto_1 = require("../auth/dto/create_admin_user.dto");
const login_user_admin_dto_1 = require("../auth/dto/login_user_admin.dto");
let AuthAdminController = class AuthAdminController {
    constructor(AuthAdminService) {
        this.AuthAdminService = AuthAdminService;
    }
    async registerAdmin(data) {
        return await this.AuthAdminService.createAdminUser(data);
    }
    async loginAdmin(data) {
        return await this.AuthAdminService.loginAdmin(data);
    }
    async refreshAccessToken(refresh_token) {
        return await this.AuthAdminService.generateRefreshAccessToken(refresh_token);
    }
};
exports.AuthAdminController = AuthAdminController;
__decorate([
    (0, common_1.Post)('/register'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_admin_user_dto_1.DtoCreateAdminUser]),
    __metadata("design:returntype", Promise)
], AuthAdminController.prototype, "registerAdmin", null);
__decorate([
    (0, common_1.Post)('/login'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [login_user_admin_dto_1.DtoLoginUserAdmin]),
    __metadata("design:returntype", Promise)
], AuthAdminController.prototype, "loginAdmin", null);
__decorate([
    (0, common_1.Post)('/token'),
    __param(0, (0, common_1.Body)('refresh_token')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AuthAdminController.prototype, "refreshAccessToken", null);
exports.AuthAdminController = AuthAdminController = __decorate([
    (0, common_1.Controller)('auth-admin'),
    __metadata("design:paramtypes", [auth_admin_service_1.AuthAdminService])
], AuthAdminController);
//# sourceMappingURL=auth_admin.controller.js.map