import { DtoCreateUser } from './dto/create_user.dto';
import { UtilsService } from '../utils/utils.service';
import { Users } from '../entities/users.entity';
import { Repository } from 'typeorm';
import { ConfigService } from '@nestjs/config';
import { JwtService } from '@nestjs/jwt';
import { DtoLoginUser } from './dto/login_user.dto';
import { MailService } from '../mail/mail.service';
import { DtoForgotPassword } from './dto/forgot_password.dto';
import { DtoChangePassword } from './dto/change_password.dto';
import { AdminUsers } from 'src/entities/admin_users.entity';
import { DtoUpdateInforUser } from './dto/update_info_user.dto';
import { CartService } from '../modules/cart/cart.service';
export declare class AuthService {
    private readonly UtilsService;
    private readonly ConfigService;
    private readonly JwtService;
    private readonly MailService;
    private readonly CartService;
    private readonly UsersRepository;
    private readonly AdminUsersRepository;
    constructor(UtilsService: UtilsService, ConfigService: ConfigService, JwtService: JwtService, MailService: MailService, CartService: CartService, UsersRepository: Repository<Users>, AdminUsersRepository: Repository<AdminUsers>);
    login(user: DtoLoginUser): Promise<{
        access_token: string;
        refresh_token: string;
    }>;
    registerUser(user: DtoCreateUser): Promise<boolean>;
    me(user: Users): Promise<{
        products_in_cart: number;
        id: number;
        name: string;
        email: string;
        password: string;
        is_active: number;
        cellphone: string;
        carts: import("../entities/cart.entity").Cart[];
        customer: import("../entities/customers.entity").Customers;
    }>;
    activateAccount(token: string): Promise<boolean>;
    forgotPassword(data: DtoForgotPassword): Promise<boolean>;
    changePassword(data: DtoChangePassword): Promise<void>;
    generateRefreshAccessToken(refresh_token: string): Promise<{
        access_token: string;
        refresh_token: string;
    }>;
    sendEmailActivation(token: string): Promise<void>;
    updateInfoUser(id: number, data: DtoUpdateInforUser): Promise<{
        name: string;
        cellphone: string;
        id: number;
    } & Users>;
}
