"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
const common_1 = require("@nestjs/common");
const auth_service_1 = require("./auth.service");
const create_user_dto_1 = require("./dto/create_user.dto");
const utils_service_1 = require("../utils/utils.service");
const login_user_dto_1 = require("./dto/login_user.dto");
const users_entity_1 = require("../entities/users.entity");
const forgot_password_dto_1 = require("./dto/forgot_password.dto");
const change_password_dto_1 = require("./dto/change_password.dto");
const user_authorization_guard_1 = require("../guards/auth/user_authorization.guard");
const user_authorization_decorator_1 = require("../decorators/user_authorization.decorator");
const update_info_user_dto_1 = require("./dto/update_info_user.dto");
let AuthController = class AuthController {
    constructor(AuthService, UtilsService) {
        this.AuthService = AuthService;
        this.UtilsService = UtilsService;
    }
    async register(user) {
        const created = await this.AuthService.registerUser(user);
        if (created) {
            this.UtilsService.response(201);
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async login(user) {
        return await this.AuthService.login(user);
    }
    async getMe(user) {
        const response = await this.AuthService.me(user);
        if (response) {
            return response;
        }
        else {
            this.UtilsService.response(401);
        }
    }
    async updateInfoUser(user, data) {
        const response = await this.AuthService.updateInfoUser(user.id, data);
        if (response) {
            return response;
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async activateAccount(token) {
        const activated = await this.AuthService.activateAccount(token);
        if (activated) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async forgotPassword(data) {
        const token = await this.AuthService.forgotPassword(data);
        if (token) {
            this.UtilsService.response(200);
        }
        else {
            this.UtilsService.response(400);
        }
    }
    async changePassword(data) {
        return await this.AuthService.changePassword(data);
    }
    async refreshAccessToken(refresh_token) {
        return await this.AuthService.generateRefreshAccessToken(refresh_token);
    }
    async resendEmailActivation(token) {
        return await this.AuthService.sendEmailActivation(token);
    }
};
exports.AuthController = AuthController;
__decorate([
    (0, common_1.Post)('/register'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_user_dto_1.DtoCreateUser]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "register", null);
__decorate([
    (0, common_1.Post)('/login'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [login_user_dto_1.DtoLoginUser]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "login", null);
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Get)('/me'),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "getMe", null);
__decorate([
    (0, common_1.UseGuards)(user_authorization_guard_1.UserAuthorizationGuard),
    (0, common_1.Put)('/user'),
    __param(0, (0, user_authorization_decorator_1.UserAuthorization)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [users_entity_1.Users, update_info_user_dto_1.DtoUpdateInforUser]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "updateInfoUser", null);
__decorate([
    (0, common_1.Get)('/activate_account/:token'),
    __param(0, (0, common_1.Param)('token')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "activateAccount", null);
__decorate([
    (0, common_1.Post)('/forgot_password'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [forgot_password_dto_1.DtoForgotPassword]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "forgotPassword", null);
__decorate([
    (0, common_1.Put)('/forgot_password'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [change_password_dto_1.DtoChangePassword]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "changePassword", null);
__decorate([
    (0, common_1.Post)('/token'),
    __param(0, (0, common_1.Body)('refresh_token')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "refreshAccessToken", null);
__decorate([
    (0, common_1.Get)('/send_email_activation/:token'),
    __param(0, (0, common_1.Param)('token')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], AuthController.prototype, "resendEmailActivation", null);
exports.AuthController = AuthController = __decorate([
    (0, common_1.Controller)('auth'),
    __metadata("design:paramtypes", [auth_service_1.AuthService, utils_service_1.UtilsService])
], AuthController);
//# sourceMappingURL=auth.controller.js.map