import { AuthService } from './auth.service';
import { DtoCreateUser } from './dto/create_user.dto';
import { UtilsService } from '../utils/utils.service';
import { DtoLoginUser } from './dto/login_user.dto';
import { Users } from 'src/entities/users.entity';
import { DtoForgotPassword } from './dto/forgot_password.dto';
import { DtoChangePassword } from './dto/change_password.dto';
import { DtoUpdateInforUser } from './dto/update_info_user.dto';
export declare class AuthController {
    private readonly AuthService;
    private readonly UtilsService;
    constructor(AuthService: AuthService, UtilsService: UtilsService);
    register(user: DtoCreateUser): Promise<void>;
    login(user: DtoLoginUser): Promise<{
        access_token: string;
        refresh_token: string;
    }>;
    getMe(user: Users): Promise<{
        products_in_cart: number;
        id: number;
        name: string;
        email: string;
        password: string;
        is_active: number;
        cellphone: string;
        carts: import("../entities/cart.entity").Cart[];
        customer: import("../entities/customers.entity").Customers;
    }>;
    updateInfoUser(user: Users, data: DtoUpdateInforUser): Promise<{
        name: string;
        cellphone: string;
        id: number;
    } & Users>;
    activateAccount(token: string): Promise<void>;
    forgotPassword(data: DtoForgotPassword): Promise<void>;
    changePassword(data: DtoChangePassword): Promise<void>;
    refreshAccessToken(refresh_token: string): Promise<{
        access_token: string;
        refresh_token: string;
    }>;
    resendEmailActivation(token: string): Promise<void>;
}
