"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const app_controller_1 = require("./app.controller");
const config_1 = require("@nestjs/config");
const typeorm_1 = require("@nestjs/typeorm");
const entities_module_1 = require("./entities/entities.module");
const auth_module_1 = require("./auth/auth.module");
const utils_module_1 = require("./utils/utils.module");
const core_1 = require("@nestjs/core");
const httpResponse_interceptor_1 = require("./interceptor/http/httpResponse.interceptor");
const mail_module_1 = require("./mail/mail.module");
const modules_module_1 = require("./modules/modules.module");
const auth_admin_module_1 = require("./auth_admin/auth_admin.module");
const ftp_module_1 = require("./ftp/ftp.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({ envFilePath: process.env.NODE_ENV ? `.${process.env.NODE_ENV}.env` : '.development.env', isGlobal: true, expandVariables: true }),
            typeorm_1.TypeOrmModule.forRootAsync({
                imports: [config_1.ConfigModule],
                useFactory: (ConfigService) => ({
                    type: 'mysql',
                    host: ConfigService.get('DB_HOST'),
                    port: ConfigService.get('DB_PORT'),
                    username: ConfigService.get('DB_USERNAME'),
                    password: ConfigService.get('DB_PASSWORD'),
                    database: ConfigService.get('DB_DATABASE'),
                    autoLoadEntities: true,
                    timezone: 'Z',
                }),
                inject: [config_1.ConfigService]
            }),
            auth_module_1.AuthModule,
            utils_module_1.UtilsModule,
            entities_module_1.EntitiesModule,
            mail_module_1.MailModule,
            modules_module_1.ModulesModule,
            auth_admin_module_1.AuthAdminModule,
            ftp_module_1.FtpModule,
        ],
        controllers: [app_controller_1.AppController],
        exports: [config_1.ConfigModule],
        providers: [
            {
                provide: core_1.APP_FILTER,
                useClass: httpResponse_interceptor_1.HttpResponse
            }
        ],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map